/****** Object:  StoredProcedure [dbo].[CP_Finan_Creditos]    Script Date: 29/3/2018 10:48:07 a. m. ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [dbo].[CP_Finan_Creditos](
				@pAmort			CHAR(1)
			,	@pCuotas		SMALLINT
			,	@pTEM			DECIMAL(12,4)
			,	@pCapital		DECIMAL(12,4)
			,	@pFechaDesde	DATETIME
			,	@pNroCutoa		SMALLINT
			,   @CuentaBanco    INT
			)
AS
 
IF  @pAmort NOT IN ('T','F','A','U')
    RETURN

DECLARE @NroCuota SMALLINT
      , @SaldoInicial	DECIMAL(16,2)
	  , @ValorCuota		DECIMAL(16,2)
	  , @Intereses		DECIMAL(16,2)
	  , @Amortizacion	DECIMAL(16,2) 
	  , @AmortACum		DECIMAL(16,2) 
	  , @SaldoFinal		DECIMAL(16,2)
	  , @Fecha			DATETIME
	  , @DifDias	    TINYINT
	  , @Fecha_Pago     DATETIME
	  


CREATE TABLE #Result (
	    Fecha			DATETIME
      , NroCuota		SMALLINT 
      , SaldoInicial	DECIMAL(16,2)
	  , ValorCuota		DECIMAL(16,2)
	  , Intereses		DECIMAL(16,2)
	  , Amortizacion	DECIMAL(16,2) 
	  , AmortACum		DECIMAL(16,2) 
	  , SaldoFinal		DECIMAL(16,2)
	  , FechaPago       DATETIME
	  )

SET @NroCuota = 1
SET @SaldoInicial	= @pCapital
SET @AmortACum = 0
SET @Fecha = @pFechaDesde
SET @Fecha_Pago = NULL
 

/*Cuota Cero*/
SET @DifDias = DATEDIFF(dd,@Fecha,EOMONTH(@Fecha))
IF ISNULL(@DifDias,0) != 0
BEGIN
		SET @Intereses		= @pCapital * (@pTEM / 100 / 30) * @DifDias
		SET @Amortizacion	= 0
		SET @ValorCuota		= @Intereses + @Amortizacion
		SET @AmortACum		= 0
		SET @SaldoFinal		= @pCapital 
		INSERT INTO #Result VALUES (@Fecha,0 , @SaldoInicial, @ValorCuota, @Intereses, @Amortizacion, @AmortACum, @SaldoFinal,@Fecha_Pago)
END 

SET @Fecha = EOMONTH(@Fecha) 
SET @Fecha = DATEADD(dd,1,@Fecha) 

WHILE @NroCuota <= @pCuotas
BEGIN
    IF UPPER(@pAmort) = 'T'   -- Tasa directa
	BEGIN
		SET @Intereses		= @pCapital * @pTEM / 100
		SET @Amortizacion	= @pCapital / @pCuotas
		SET @ValorCuota		= @Intereses + @Amortizacion
		SET @AmortACum		= @AmortACum + @Amortizacion
		SET @SaldoFinal		= @pCapital - @AmortACum
    END

    IF UPPER(@pAmort) = 'F'   -- Frances
	BEGIN
		SET @ValorCuota		= @pCapital * ( @pTEM / 100) / (1 -(POWER( (1+( @pTEM / 100)),(@pCuotas * -1) ) ) )   
		SET @Intereses		= @SaldoInicial * @pTEM / 100
		SET @Amortizacion	= @ValorCuota - @Intereses
		SET @AmortACum		= @AmortACum + @Amortizacion
		SET @SaldoFinal		= @pCapital - @AmortACum
    END

    IF UPPER(@pAmort) = 'A'   -- Aleman
	BEGIN
		SET @ValorCuota		= (@pCapital / @pCuotas) + ( @SaldoInicial * ( @pTEM / 100) )
		SET @Intereses		= @SaldoInicial * @pTEM / 100
		SET @Amortizacion	= @pCapital / @pCuotas
		SET @AmortACum		= @AmortACum + @Amortizacion
		SET @SaldoFinal		= @pCapital - @AmortACum
    END

    IF UPPER(@pAmort) = 'U'   -- Americano
	BEGIN
		SET @Intereses		= @pCapital * @pTEM / 100
		IF @NroCuota = @pCuotas
			SET @Amortizacion	= @pCapital  
		ELSE 
			SET @Amortizacion	= 0 
		SET @ValorCuota		= @Intereses + @Amortizacion
		SET @AmortACum		= @AmortACum + @Amortizacion
		SET @SaldoFinal		= @pCapital - @AmortACum

    END
	IF @CuentaBanco > 0
	   BEGIN
		 SET @Fecha_Pago = (Select Max(ISNULL(R.FECHA,'')) From Cbtes_Items i, Cbtes C , CBTES_TIPOS T,CBTES_APLICA A, CBTES R 
						   Where C.Id_Trans = I.Id_Trans 
						   AND A.ID_TRANS = C.ID_TRANS 
						   AND A.ID_TRANS_D = R.ID_TRANS
						   And C.Id_Estado_Cbte = 2 and I.Id_Producto = 'AMORTIZA'
						   AND DATEPART(MM,I.Fecha_QA) = DATEPART(MM,@Fecha) 
						   AND DATEPART(YYYY,I.Fecha_QA) = DATEPART(YYYY,@Fecha) 
						   And C.Id_tipo_Cbte = T.Id_Tipo_cbte And T.Compromete_Factura = 1
						   And I.Id_Cta_Banco =  @CuentaBanco ) 
         END

    INSERT INTO #Result VALUES (@Fecha,@NroCuota , @SaldoInicial, @ValorCuota, @Intereses, @Amortizacion, @AmortACum, @SaldoFinal,@Fecha_Pago)
	SET @NroCuota = @NroCuota + 1
	SET @SaldoInicial = @SaldoFinal
	SET @Fecha = DATEADD(mm,1,@Fecha)
END 

IF @SaldoFinal <> 0 
BEGIN
	UPDATE #Result SET Amortizacion = @Amortizacion + @SaldoFinal
	                 , ValorCuota = @ValorCuota + @SaldoFinal 
					 , AmortACum = @AmortACum + @SaldoFinal
					 , SaldoFinal = 0
	WHERE NroCuota = @pCuotas
END
IF ISNULL(@pNroCutoa,0) = 0
   SELECT * FROM #Result
ELSE
   SELECT * FROM #Result WHERE NroCuota = @pNroCutoa



DROP TABLE #Result

